class Rock < Projectile
  def initialize(args, params)
    super
    @path = "sprites/projectiles/rock.png"
    @size = {w: 16, h: 20}
    @position = params[:position] if params[:position]
    @direction = params[:direction] if params[:direction]
  end

  def to_h
    {x: @position.x, y: @position.y, w: @size.w, h: @size.h, path: @path, direction: @direction, primitive_marker: :solid, r: 0, g: 0, b: 128}
  end

  def inspect
    serialize.to_s
  end

  def serialize
    to_h
  end

  def to_s
    serialize.to_s
  end
end